/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.internal.startpage;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.internal.Portal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartPageUtil {
    public static String getStartPageURL() {
        String dashboardUrl = EclipseUtil.getSystemProperty((String)"studio.startPageUrl");
        if (dashboardUrl == null) {
            dashboardUrl = "http://content.aptana.com/aptana/my_aptana/?content=start";
        }
        return dashboardUrl;
    }

    public static void showStartPage(boolean bringToTop) {
        StartPageUtil.showStartPage(bringToTop, null);
    }

    public static void showStartPage(boolean bringToTop, Map<String, String> additionalParameters) {
        try {
            Portal.getInstance().openPortal(new URL(StartPageUtil.getStartPageURL()), "com.aptana.portal.ui.browser.startPage", bringToTop, additionalParameters);
            String currentVersion = StartPageUtil.getCurrentVersion();
            if (currentVersion != null) {
                IEclipsePreferences store = InstanceScope.INSTANCE.getNode("com.aptana.portal.ui");
                store.put("last_known_studio_version", currentVersion);
                try {
                    store.flush();
                }
                catch (BackingStoreException e) {
                    IdeLog.logWarning((Plugin)PortalUIPlugin.getDefault(), (String)"Error saving the last studio version", (Throwable)e, (String)"com.aptana.portal.ui/debug/startpage");
                }
            }
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Malformed URL for the Studio's Start Page", (Throwable)e);
        }
    }

    public static boolean shouldShowStartPage() {
        if (EclipseUtil.getPluginVersion((String)"com.appcelerator.titanium.rcp") != null) {
            return false;
        }
        IEclipsePreferences store = InstanceScope.INSTANCE.getNode("com.aptana.portal.ui");
        String lastVersion = store.get("last_known_studio_version", null);
        if (lastVersion == null) {
            return true;
        }
        String currentVersion = StartPageUtil.getCurrentVersion();
        if (currentVersion == null) {
            return false;
        }
        return !lastVersion.equals(currentVersion);
    }

    private static String getCurrentVersion() {
        String version = CorePlugin.getAptanaStudioVersion();
        if (version == null && !Platform.inDevelopmentMode()) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Could not identify the Studio's version");
        }
        return version;
    }
}

